package gov.va.genisis2.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer role type related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "roleType")
@JsonInclude(Include.NON_NULL)
public class RoleTypeDTO implements Serializable {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -6869033019395474546L;

	private int roleTypeId;
	private String roleName;
	private String roleDescription;

	/**
	 * @return the roleTypeId
	 */
	public int getRoleTypeId() {
		return roleTypeId;
	}

	/**
	 * @param roleTypeId
	 *            the roleTypeId to set
	 */
	public void setRoleTypeId(int roleTypeId) {
		this.roleTypeId = roleTypeId;
	}

	/**
	 * @return the roleName
	 */
	public String getRoleName() {
		return roleName;
	}

	/**
	 * @param roleName
	 *            the roleName to set
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	/**
	 * @return the roleDescription
	 */
	public String getRoleDescription() {
		return roleDescription;
	}

	/**
	 * @param roleDescription
	 *            the roleDescription to set
	 */
	public void setRoleDescription(String roleDescription) {
		this.roleDescription = roleDescription;
	}
}